<?php
require_once __DIR__ . '/../config/db.php';

try {
    echo "Starting delivery table update migration...\n";
    
    // Check if deliveries table exists
    $stmt = $pdo->prepare("SHOW TABLES LIKE 'deliveries'");
    $stmt->execute();
    $tableExists = $stmt->fetch();
    
    if (!$tableExists) {
        echo "Creating deliveries table...\n";
        
        // Create deliveries table with quotation support
        $sql = "
        CREATE TABLE deliveries (
            id INT AUTO_INCREMENT PRIMARY KEY,
            delivery_number VARCHAR(20) UNIQUE NOT NULL,
            customer_id INT,
            assigned_to INT,
            delivery_phone VARCHAR(20) NOT NULL,
            delivery_address TEXT NOT NULL,
            scheduled_date DATETIME NOT NULL,
            delivery_notes TEXT,
            delivery_fee DECIMAL(10,2) DEFAULT 0.00,
            payment_method ENUM('cash', 'paid', 'credit') DEFAULT 'cash',
            status ENUM('pending', 'in-transit', 'delivered', 'cancelled') DEFAULT 'pending',
            quotation_id INT NULL,
            quotation_reference VARCHAR(50) NULL,
            created_by INT NOT NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            delivered_at TIMESTAMP NULL,
            delivered_by INT NULL,
            FOREIGN KEY (customer_id) REFERENCES customers(id) ON DELETE SET NULL,
            FOREIGN KEY (assigned_to) REFERENCES users(id) ON DELETE SET NULL,
            FOREIGN KEY (created_by) REFERENCES users(id) ON DELETE RESTRICT,
            FOREIGN KEY (delivered_by) REFERENCES users(id) ON DELETE SET NULL,
            FOREIGN KEY (quotation_id) REFERENCES quotations(id) ON DELETE SET NULL,
            INDEX idx_delivery_number (delivery_number),
            INDEX idx_customer_id (customer_id),
            INDEX idx_status (status),
            INDEX idx_scheduled_date (scheduled_date),
            INDEX idx_quotation_id (quotation_id)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
        ";
        
        $pdo->exec($sql);
        echo "Deliveries table created successfully!\n";
        
    } else {
        echo "Deliveries table exists. Checking for quotation fields...\n";
        
        // Check if quotation_id column exists
        $stmt = $pdo->prepare("SHOW COLUMNS FROM deliveries LIKE 'quotation_id'");
        $stmt->execute();
        $quotationIdExists = $stmt->fetch();
        
        if (!$quotationIdExists) {
            echo "Adding quotation_id column...\n";
            $pdo->exec("ALTER TABLE deliveries ADD COLUMN quotation_id INT NULL AFTER status");
            $pdo->exec("ALTER TABLE deliveries ADD FOREIGN KEY (quotation_id) REFERENCES quotations(id) ON DELETE SET NULL");
            $pdo->exec("ALTER TABLE deliveries ADD INDEX idx_quotation_id (quotation_id)");
            echo "quotation_id column added successfully!\n";
        }
        
        // Check if quotation_reference column exists
        $stmt = $pdo->prepare("SHOW COLUMNS FROM deliveries LIKE 'quotation_reference'");
        $stmt->execute();
        $quotationRefExists = $stmt->fetch();
        
        if (!$quotationRefExists) {
            echo "Adding quotation_reference column...\n";
            $pdo->exec("ALTER TABLE deliveries ADD COLUMN quotation_reference VARCHAR(50) NULL AFTER quotation_id");
            echo "quotation_reference column added successfully!\n";
        }
        
        // Check if delivered_at column exists
        $stmt = $pdo->prepare("SHOW COLUMNS FROM deliveries LIKE 'delivered_at'");
        $stmt->execute();
        $deliveredAtExists = $stmt->fetch();
        
        if (!$deliveredAtExists) {
            echo "Adding delivered_at column...\n";
            $pdo->exec("ALTER TABLE deliveries ADD COLUMN delivered_at TIMESTAMP NULL AFTER updated_at");
            echo "delivered_at column added successfully!\n";
        }
        
        // Check if delivered_by column exists
        $stmt = $pdo->prepare("SHOW COLUMNS FROM deliveries LIKE 'delivered_by'");
        $stmt->execute();
        $deliveredByExists = $stmt->fetch();
        
        if (!$deliveredByExists) {
            echo "Adding delivered_by column...\n";
            $pdo->exec("ALTER TABLE deliveries ADD COLUMN delivered_by INT NULL AFTER delivered_at");
            $pdo->exec("ALTER TABLE deliveries ADD FOREIGN KEY (delivered_by) REFERENCES users(id) ON DELETE SET NULL");
            echo "delivered_by column added successfully!\n";
        }
    }
    
    echo "Delivery table migration completed successfully!\n";
    
} catch (PDOException $e) {
    echo "Error during migration: " . $e->getMessage() . "\n";
    exit(1);
}
?> 